package ru.yandex.logbroker2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class Logbroker2SingleConsumerConfigBuilder
    extends AbstractLogbroker2SingleConsumerConfigBuilder<
        Logbroker2SingleConsumerConfigBuilder>
{
    public Logbroker2SingleConsumerConfigBuilder() {
        super(Logbroker2SingleConsumerConfigDefaults.INSTANCE);
    }

    public Logbroker2SingleConsumerConfigBuilder(
        final Logbroker2SingleConsumerConfig config)
    {
        super(config);
    }

    public Logbroker2SingleConsumerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, Logbroker2SingleConsumerConfigDefaults.INSTANCE);
    }

    public Logbroker2SingleConsumerConfigBuilder(
        final IniConfig config,
        final Logbroker2SingleConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public Logbroker2SingleConsumerConfigBuilder self() {
        return this;
    }

    public ImmutableLogbroker2SingleConsumerConfig build() throws ConfigException {
        return new ImmutableLogbroker2SingleConsumerConfig(this);
    }
}

