package ru.yandex.logbroker2.config;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.logbroker2.LBDataFormat;

public class Logbroker2SingleConsumerConfigDefaults
    implements Logbroker2SingleConsumerConfig
{
    public static final Logbroker2SingleConsumerConfigDefaults INSTANCE =
        new Logbroker2SingleConsumerConfigDefaults();
    private static final int DEFAULT_BALANCER_PORT = 2135;
    private static final int DEFAULT_PROXY_PORT = 2135;
    private static final int DEFAULT_PREFETCH_COUNT = 10000;
    private static final long DEFAULT_PREFETCH_DATA_SIZE = 256 * 1024 * 1024;
    private static final int DEFAULT_PER_TOPIC_PREFETCH_COUNT = 1000;
    private static final long DEFAULT_PER_TOPIC_PREFETCH_DATA_SIZE =
        32 * 1024 * 1024;
    private static final int DEFAULT_SEND_BATCH_SIZE = 1;

    protected Logbroker2SingleConsumerConfigDefaults() {
    }

    @Override
    public URIConfigDefaults targetConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public Set<String> balancerHosts() {
        return Collections.emptySet();
    }

    @Override
    public int balancerPort() {
        return DEFAULT_BALANCER_PORT;
    }

    @Override
    public int proxyPort() {
        return DEFAULT_PROXY_PORT;
    }

    @Override
    public int prefetchCount() {
        return DEFAULT_PREFETCH_COUNT;
    }

    @Override
    public long prefetchDataSize() {
        return DEFAULT_PREFETCH_DATA_SIZE;
    }

    @Override
    public int perTopicPrefetchCount() {
        return DEFAULT_PER_TOPIC_PREFETCH_COUNT;
    }

    @Override
    public long perTopicPrefetchDataSize() {
        return DEFAULT_PER_TOPIC_PREFETCH_DATA_SIZE;
    }

    @Override
    public Map<String, Integer> sendBatchSize() {
        return Collections.singletonMap(null, DEFAULT_SEND_BATCH_SIZE);
    }

    @Override
    public Set<String> topics() {
        return Collections.emptySet();
    }

    @Override
    public String clientId() {
        return null;
    }

    @Override
    public boolean readOnlyLocal() {
        return false;
    }

    @Override
    public boolean gzipRequests() {
        return false;
    }

    @Override
    public String tvmClientId() {
        return null;
    }

    @Override
    public IamJwtConfig iamConfig() {
        return IamJwtConfigDefaults.INSTANCE;
    }

    @Override
    public LBDataFormat dataFormat() {
        return LBDataFormat.RAW;
    }

    @Override
    public Map<String, FieldConfig> fieldsConfig() {
        return Collections.emptyMap();
    }
}
