#!/bin/bash
set -xo pipefail

export SERVICE_PORT=$BSCONFIG_IPORT
export READ_ONLY_LOCAL=false
export SERVICE_CONFIG="empty.conf"
export GZIP_REQUESTS=false
export CONFIG_PATH=consumer.conf
export LB_TVM_CLIENT_ID=2001059

export GEO_DC=$(cat dump.json | jq -r .properties.BSCONFIG_ITAGS | egrep -o "a_geo_[a-z]+")
if [ "$GEO_DC" == "" ]; then
    export GEO_DC="a_geo_"$a_dc
fi

case "$GEO_DC" in
    a_geo_sas)
        export BALANCER_HOSTS_LOCAL=sas.logbroker.yandex.net
        ;;
    a_geo_myt)
        export BALANCER_HOSTS_LOCAL=myt.logbroker.yandex.net
        ;;
    a_geo_iva)
        export BALANCER_HOSTS_LOCAL=iva.logbroker.yandex.net
        ;;
    a_geo_vla)
        export BALANCER_HOSTS_LOCAL=vla.logbroker.yandex.net
        ;;
    a_geo_man)
        export BALANCER_HOSTS_LOCAL=man.logbroker.yandex.net
        ;;
esac

if test -x "$NANNY_SERVICE_ID.sh"
then
    source "$NANNY_SERVICE_ID.sh"
fi

case "$NANNY_SERVICE_ID" in
    messenger_search_logbroker_consumer_test)
        export TARGET_URI=http://messenger-search-malo-test.n.yandex-team.ru/
        export CLIENT_ID=mssngr-search-indexation-test-client
        export TOPICS=mssngr--test-search-chats,mssngr--test-search-users,mssngr--test-search-messages,mssngr--test-search-contacts,mssngr--test-search-chat-members,mssngr--test-search-buckets
        export BALANCER_HOSTS=messenger.logbroker.yandex.net
        export SRC_CLIENT_ID=2001772
        export SEND_BATCH_SIZE=50
        ;;
    messenger_search_logbroker_consumer_prod)
        export TARGET_URI=http://messenger-malo.pers.yandex.net:12929/
        export CLIENT_ID=mssngr-search-indexation-prod-client
        export TOPICS=mssngr--prod-search-chats,mssngr--prod-search-users,mssngr--prod-search-messages,mssngr--prod-search-chat-members,mssngr--prod-search-buckets
        #export TOPICS=mssngr--prod-search-chats,mssngr--prod-search-users,mssngr--prod-search-messages,mssngr--prod-search-contacts,mssngr--prod-search-chat-members,mssngr--prod-search-buckets
        export BALANCER_HOSTS=messenger.logbroker.yandex.net
        export SRC_CLIENT_ID=2001774
        export SEND_BATCH_SIZE=200
        export SERVICE_CONFIG="messenger.conf"
        ;;
    messenger_search_logbroker_consumer_contacts_prod)
        export TARGET_URI=http://messenger-malo.pers.yandex.net:12929/
        export CLIENT_ID=mssngr-search-indexation-prod-client
        export TOPICS=mssngr--prod-search-contacts
        export BALANCER_HOSTS=messenger.logbroker.yandex.net
        export SRC_CLIENT_ID=2001774
        export SEND_BATCH_SIZE=200
        export SERVICE_CONFIG="messenger.conf"
        ;;
    messenger_search_logbroker_consumer_alpha)
        export TARGET_URI=http://messenger-malo-alpha.pers.yandex.net:26895/
        export CLIENT_ID=mssngr-search-indexation-alpha-client
        export TOPICS=mssngr--alpha-search-chats,mssngr--alpha-search-users,mssngr--alpha-search-messages,mssngr--alpha-search-contacts,mssngr--alpha-search-chat-members,mssngr--alpha-search-buckets
        export BALANCER_HOSTS=messenger.logbroker.yandex.net
        export SRC_CLIENT_ID=2002052
        export SEND_BATCH_SIZE=50
        export SERVICE_CONFIG="messenger.conf"
        ;;
    mail-logbroker-consumer-prod)
        export TARGET_URI=http://iex-proxy-prod3.n.yandex-team.ru/calendar-log-handle
        export CLIENT_ID=/mail-search/calendar-consumer
        export TOPICS=calendar-public--calendar-public-events-log-json,calendar-yt--calendar-yt-events-log-json
        export BALANCER_HOSTS=sas.logbroker.yandex.net,man.logbroker.yandex.net,myt.logbroker.yandex.net,iva.logbroker.yandex.net,vla.logbroker.yandex.net
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2000031
        export SEND_BATCH_SIZE=1
        export SERVICE_PORT=$((BSCONFIG_IPORT+1))
        ;;
    blackbox-logbroker-consumer)
        export TARGET_URI=http://so-fraud.pers.yandex.net/logbroke-it
        export CLIENT_ID=passport/lbc-passport-auth-log
        export TOPICS=passport/passport-auth-log
        export BALANCER_HOSTS=$BALANCER_HOSTS_LOCAL
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2000031
        export SEND_BATCH_SIZE=20
        export GZIP_REQUESTS=true
        ;;
    passport-logbroker-consumer)
        export TARGET_URI=http://fraud.so.yandex-team.ru/passport-logbroke-it
        export CLIENT_ID=/mail-so/antifraud-auth
        export TOPICS=mail-so/mail-so-antifraud-auth-log
        export BALANCER_HOSTS=$BALANCER_HOSTS_LOCAL
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2000031
        export SEND_BATCH_SIZE=10
        export GZIP_REQUESTS=true
        ;;
    passport-test-logbroker-consumer)
        export TARGET_URI=http://fraud-test.so.yandex-team.ru/passport-logbroke-it
        export CLIENT_ID=/mail-so/antifraud-auth
        export TOPICS=mail-so/mail-so-antifraud-auth-test-log
        export BALANCER_HOSTS=$BALANCER_HOSTS_LOCAL
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2000031
        export SEND_BATCH_SIZE=10
        export GZIP_REQUESTS=true
        ;;
    passport-test-logbroker-consumer)
        export TARGET_URI=http://fraud-test.so.yandex-team.ru/passport-logbroke-it
        export CLIENT_ID=/mail-so/antifraud-auth
        export TOPICS=mail-so/mail-so-antifraud-auth-test-log
        export BALANCER_HOSTS=$BALANCER_HOSTS_LOCAL
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2000031
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=10
        export GZIP_REQUESTS=true
        ;;
    passport-logbroker-consumer-plus)
        export TARGET_URI=http://fraud.so.yandex-team.ru/logbroke-it-plus
        export CLIENT_ID=/mail-so/antifraud-auth-plus
        export TOPICS=mail-so/mail-so-antifraud-auth-log
        export BALANCER_HOSTS=$BALANCER_HOSTS_LOCAL
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2000031
        export SEND_BATCH_SIZE=10
        export GZIP_REQUESTS=true
        ;;
    familypay_lbconsumer)
        export TARGET_URI=https://familypay-backend.so.yandex.net/update-family
        export CLIENT_ID=/familypay/passport-family-events-consumer
        export TOPICS=passport/passport-family-events-log
        export BALANCER_HOSTS=sas.logbroker.yandex.net,man.logbroker.yandex.net,myt.logbroker.yandex.net,iva.logbroker.yandex.net,vla.logbroker.yandex.net
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2021718
        export LB_TVM_CLIENT_ID=2001059
        export SERVICE_CONFIG="familypay.conf"
        export EXTRA_CONFIG="empty.conf"
        export SEND_BATCH_SIZE=1
        ;;
    familypay_lbconsumer_test)
        export TARGET_URI=https://familypay-backend-test.so.yandex.net/update-family
        export CLIENT_ID=/familypay/passport-test-family-events-consumer
        export TOPICS=passport/passport-family-events-testing-log
        export BALANCER_HOSTS=sas.logbroker.yandex.net,man.logbroker.yandex.net,myt.logbroker.yandex.net,iva.logbroker.yandex.net,vla.logbroker.yandex.net
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2021716
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=1
        export SERVICE_CONFIG="familypay.conf"
        export EXTRA_CONFIG="debug-flags.conf"
        export DEBUG_FLAGS=log-payload
        ;;
    familypay_cards_lbconsumer)
        export TARGET_URI=https://familypay-backend.so.yandex.net/update-card-info
        export CLIENT_ID=/familypay/cards-events-consumer
        export TOPICS=trust/prod/card-events
        export BALANCER_HOSTS=lbkx.logbroker.yandex.net
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2021718
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=1
        export SERVICE_CONFIG="familypay-cards.conf"
        export EXTRA_CONFIG="empty.conf"
        ;;
    familypay_cards_lbconsumer_test)
        export TARGET_URI=https://familypay-backend-test.so.yandex.net/update-card-info
        export CLIENT_ID=/familypay/cards-events-consumer-test
        export TOPICS=trust/test/card-events
        export BALANCER_HOSTS=lbkx.logbroker.yandex.net
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2021716
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=1
        export SERVICE_CONFIG="familypay-cards.conf"
        export EXTRA_CONFIG="debug-flags.conf"
        export DEBUG_FLAGS=log-payload
        ;;
    korobochka-logbroker-consumer)
        export TARGET_URI=http://korobochka-proxy.passport.yandex.net/logbroke-it-plus-korobochka
        export CLIENT_ID=passport/korobochka-consumer
        export TOPICS=passport/passport-account-modification-log,autoru-mirage/lb/auto_ru,historydb2/production/event
        export BALANCER_HOSTS=$BALANCER_HOSTS_LOCAL
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2031262
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=10
        export GZIP_REQUESTS=true
        ;;
esac
