#!/bin/bash
set -x

source config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_PRELOAD=$BSCONFIG_IDIR/libtcmalloc_minimal.so

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

if [ $CPU_CORES -eq 0 ]
then
    export CPU_CORES=1
fi

if jdk/bin/java -version 2>&1 | fgrep -q -e OpenJ9 -e Ibm -e IBM; then
    GC_ARGS="
    -Xgcpolicy:gencon
    -XX:ActiveProcessorCount=$CPU_CORES
    -Xgcthreads$CPU_CORES -verbose:gc -Xverbosegclog:/dev/shm/gclogs/gc#.log,10,10000
    -Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
else
    if [ "$G1" == "true" ]; then
        GC_ARGS="
            -XX:ActiveProcessorCount=$CPU_CORES
            -XX:+IgnoreUnrecognizedVMOptions
            -XX:+PrintGC
            -XX:+PrintGCDetails
            -XX:+UnlockExperimentalVMOptions
            -verbose:gc
            -XX:+UseG1GC
            -XX:ConcGCThreads=1
            -XX:ParallelGCThreads=$CPU_CORES
            -XX:+UnlockDiagnosticVMOptions
            -XX:+PrintGCDateStamps
            -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
            -XX:MaxGCPauseMillis=10
            -XX:G1MixedGCCountTarget=32
            -XX:G1HeapWastePercent=20
            -XX:G1AdaptiveIHOPNumInitialSamples=10
            -Xloggc:/dev/shm/gc.log"
    else
        GC_ARGS="
        -XX:ActiveProcessorCount=$CPU_CORES
        -XX:+PrintGC
        -XX:+PrintGCDetails
        -XX:+UnlockExperimentalVMOptions
        -verbose:gc
        -XX:+UseShenandoahGC
        -XX:ConcGCThreads=1
        -XX:ShenandoahGCMode=traversal
        -XX:-ShenandoahAlwaysClearSoftRefs
        -XX:ShenandoahAllocationThreshold=10
        -XX:ShenandoahGuaranteedGCInterval=30000
        -XX:ParallelGCThreads=$CPU_CORES
        -XX:+UnlockDiagnosticVMOptions
        -Xloggc:/dev/shm/gc.log
        "
    fi
fi

MEM_ARGS="-Xmx$MEMORY_LIMIT"

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

ADDITIONAL_ARGS="-DPORTO=1"

ARGS=(ru.yandex.logbroker2.Logbroker2Consumer $CONFIG_PATH)

if ! test -z $ADDITIONAL_SERVICES_ARGS
then
    ARGS=(ru.yandex.multistarter.MultiStarter ${ARGS[@]} ";" ${ADDITIONAL_SERVICES_ARGS[@]})
fi

JAVA_LIBRARY_PATH=.:logbroker2_consumer

if ! test -z $ADDITIONAL_LIRBARY_PATH
then
    JAVA_LIBRARY_PATH=$JAVA_LIBRARY_PATH:$ADDITIONAL_LIRBARY_PATH
fi

exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $GC_ARGS $NET_ARGS $ADDITIONAL_ARGS \
    -Djava.library.path=$JAVA_LIBRARY_PATH \
    -cp $CLASSPATH ${ARGS[@]}
