package ru.yandex.logbroker;

import java.util.Arrays;

import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class LagsStater implements Stater {
    private static final String MS_AMMM = "-ms_ammm";
    private static final int[] DEFAULT_BOUNDARIES
        = new int[] {10, 25, 50, 75, 100, 150, 300, 600, 1200, 3000, 6000};
    private final Iterable<Long> data;
    private final String prefix;
    private final int[] boundaries;

    public LagsStater(final Iterable<Long> data, final String prefix) {
        this(
            data,
            prefix,
            DEFAULT_BOUNDARIES);
    }

    public LagsStater(
        final Iterable<Long> data,
        final String prefix,
        final int[] boundaries)
    {
        this.data = data;
        this.prefix = prefix;
        this.boundaries = Arrays.copyOf(boundaries, boundaries.length);
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int count = 0;
        int[] lagDistribution = new int[boundaries.length + 1];
        loopTimes:
        for (Long lag: data) {
            ++count;
            for (int boundaryNumber = 0;
                 boundaryNumber < boundaries.length;
                 ++boundaryNumber)
            {
                if (lag < boundaries[boundaryNumber]) {
                    ++lagDistribution[boundaryNumber];
                    continue loopTimes;
                }
            }
            ++lagDistribution[boundaries.length];
        }
        for (int i = 0; i < boundaries.length; ++i) {
            statsConsumer.stat(
                prefix + "-time-less-" + boundaries[i] + MS_AMMM,
                lagDistribution[i]);
        }
        statsConsumer.stat(
            prefix + "-time-greater-"
                + boundaries[boundaries.length - 1] + MS_AMMM,
            lagDistribution[boundaries.length]);
        statsConsumer.stat(prefix + "-times-counter_ammm", count);
    }
}
