package ru.yandex.logbroker;

import org.apache.http.HttpHost;

public class LogbrokerDc {
    private final String name;
    private final HttpHost balancer;

    public LogbrokerDc(final String name, final HttpHost balancer) {
        this.name = name;
        this.balancer = balancer;
    }

    public String name() {
        return name;
    }

    public HttpHost balancer() {
        return balancer;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LogbrokerDc) {
            return name.equals(((LogbrokerDc) o).name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public String toString() {
        return "LogbrokerDc{"
            + "name='" + name + '\''
            + ", balancer=" + balancer
            + '}';
    }
}
