package ru.yandex.logbroker;

import java.io.IOException;
import java.io.Reader;

import ru.yandex.logbroker.log.LogbrokerTskvRecord;
import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvParser;

public class LogbrokerInplaceTskvParser
    extends TskvParser<LogbrokerTskvRecord>
{
    protected long parseTime = 0;
    protected LogbrokerTskvRecord record;

    public LogbrokerInplaceTskvParser() {
        super(null);
    }

    public LogbrokerTskvRecord next(final Reader reader)
        throws IOException, TskvException, NumberFormatException
    {
        record = null;
        long start = System.currentTimeMillis();
        parseWithException(reader);
        if (record != null) {
            this.record.finish();
        }

        parseTime += System.currentTimeMillis() - start;
        return record;
    }

    @Override
    protected LogbrokerTskvRecord createRecord() {
        return new LogbrokerTskvRecord();
    }

    public long parseTime() {
        return parseTime;
    }

    @Override
    protected boolean handle(
        final LogbrokerTskvRecord record)
        throws TskvException
    {
        this.record = record;
        return false;
    }
}
