package ru.yandex.logbroker;

public interface Stoppable {
    long CHECK_PREIOD = 100;

    void stop();

    boolean stopped();

    default boolean waitStop(final long deadline) throws InterruptedException {
        long left = deadline - System.currentTimeMillis();
        while (left > 0 && !stopped()) {
            Thread.sleep(CHECK_PREIOD);
            left = deadline - System.currentTimeMillis();
        }

        if (left > 0) {
            return true;
        }

        System.out.println(
            this.getClass().getName()
                + " failed to stop" + System.currentTimeMillis());
        return false;
    }
}
