package ru.yandex.logbroker.client;

import java.util.List;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.logbroker.client.exception.LogbrockerClientException;

public interface AuthorizedLogbrokerClient extends LogbrokerClient {
    Session session(final Partition partition)
        throws LogbrockerClientException;

    Session session(
        final Partition partition,
        final boolean transferable)
        throws LogbrockerClientException;

    List<Partition> suggest(final String topic, final int count)
        throws LogbrockerClientException;

    List<Partition> suggest(final List<String> topics, final int count)
        throws LogbrockerClientException;

    List<Partition> suggest(
        final List<String> topics,
        final String dc,
        final int count)
        throws LogbrockerClientException;

    OffsetInfo offsets(final Partition partition)
        throws LogbrockerClientException;

    List<OffsetInfo> offsets(final List<Partition> partitions)
        throws LogbrockerClientException;

    List<OffsetInfo> offsets(final String topic)
        throws LogbrockerClientException;

    ImmutableHttpHostConfig hostConfig();

    String clientId();
}
