package ru.yandex.logbroker.client;

import java.util.Map;

import ru.yandex.logbroker.client.exception.ParseException;

public class BasicOffsetInfo implements OffsetInfo {
    private Partition partition;
    private long offset;
    private long logStart;
    private long logSize;
    private long lag;
    private String owner;

    public BasicOffsetInfo() {
    }

    public static OffsetInfo fromMap(final Map<String, String> dict)
        throws ParseException
    {
        String topic = dict.get("topic");
        if (topic == null) {
            throw new ParseException("No topic returned");
        }

        String partition = dict.get("partition");
        if (partition == null) {
            throw new ParseException("No partition returned");
        }

        return fromMap(new BasicPartition(partition, null, -1, topic), dict);
    }

    public static OffsetInfo fromMap(
        final Partition partition,
        final Map<String, String> dict)
        throws ParseException
    {
        BasicOffsetInfo info = new BasicOffsetInfo();
        info.setPartition(partition);
        info.setOwner(dict.get("owner"));
        try {
            info.setOffset(Long.parseLong(dict.get("offset")));
            info.setLag(Long.parseLong(dict.get("lag")));
            info.setLogStart(Long.parseLong(dict.get("logStart")));
            info.setLogSize(Long.parseLong(dict.get("logSize")));
        } catch (NumberFormatException nfe) {
            throw new ParseException(
                "Invalid format, expecting long " + dict.toString(), nfe);
        }

        return info;
    }

    private void setPartition(final Partition partition) {
        this.partition = partition;
    }

    private void setOffset(final long offset) {
        this.offset = offset;
    }

    private void setLogStart(final long logStart) {
        this.logStart = logStart;
    }

    private void setLogSize(final long logSize) {
        this.logSize = logSize;
    }

    private void setLag(final long lag) {
        this.lag = lag;
    }

    private void setOwner(final String owner) {
        this.owner = owner;
    }

    @Override
    public Partition partition() {
        return partition;
    }

    @Override
    public long offset() {
        return offset;
    }

    @Override
    public long logStart() {
        return logStart;
    }

    @Override
    public long logSize() {
        return logSize;
    }

    @Override
    public long lag() {
        return lag;
    }

    @Override
    public String owner() {
        return owner;
    }
}
