package ru.yandex.logbroker.client;

import java.io.InputStream;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.io.SessionInputBuffer;

import ru.yandex.logger.PrefixedLogger;

public class LogbrokerManagedHttpClientConnection
    extends DefaultManagedHttpClientConnection
{
    private final MessageConstraints constraints;
    private final PrefixedLogger logger;

    // CSOFF: ParameterNumber
    public LogbrokerManagedHttpClientConnection(
        final String id,
        final int buffersize,
        final int fragmentSizeHint,
        final CharsetDecoder chardecoder,
        final CharsetEncoder charencoder,
        final MessageConstraints constraints,
        final ContentLengthStrategy incomingContentStrategy,
        final ContentLengthStrategy outgoingContentStrategy,
        final HttpMessageWriterFactory<HttpRequest> requestWriterFactory,
        final HttpMessageParserFactory<HttpResponse> responseParserFactory,
        final PrefixedLogger logger)
    {
        super(
            id,
            buffersize,
            fragmentSizeHint,
            chardecoder,
            charencoder,
            constraints,
            incomingContentStrategy,
            outgoingContentStrategy,
            requestWriterFactory,
            responseParserFactory);

        this.constraints = constraints;
        this.logger = logger;
    }
    // CSON: ParameterNumber

    public LogbrokerManagedHttpClientConnection(
        final String id,
        final int buffersize)
    {
        super(id, buffersize);

        this.constraints = null;
        this.logger = null;
    }

    @Override
    protected InputStream createInputStream(
        final long len,
        final SessionInputBuffer inbuffer)
    {
        if (len == ContentLengthStrategy.CHUNKED) {
            return new ChunkedInputStream(inbuffer, constraints, logger);
        }

        return super.createInputStream(len, inbuffer);
    }
}
