package ru.yandex.logbroker.client;

import java.io.Closeable;
import java.io.IOException;

public class ReadSession implements Closeable {
    private boolean closed = false;

    private final ChunkedInputStream stream;
    private final Closeable resourceLiberator;
    private final Session session;

    public ReadSession(
        final ChunkedInputStream stream,
        final Closeable resourceLiberator,
        final Session session)
    {
        this.stream = stream;
        this.resourceLiberator = resourceLiberator;
        this.session = session;
    }

    public ChunkedInputStream stream() {
        return stream;
    }

    public Session session() {
        return session;
    }

    @Override
    public void close() throws IOException {
        synchronized (this) {
            if (closed) {
                return;
            }

            closed = true;
        }

        resourceLiberator.close();
    }
}
