package ru.yandex.logbroker.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;

import ru.yandex.http.config.ImmutableDnsConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.logbroker.client.exception.LogbrockerClientException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.stater.RequestsStater;

public class SimpleLogbrokerClient extends AbstractLogbrokerClient {
    protected final ImmutableHttpHostConfig hostConfig;

    // CSOFF: ParameterNumber
    public SimpleLogbrokerClient(
        final ImmutableHttpHostConfig hostConfig,
        final ImmutableDnsConfig dnsConfig,
        final RequestsStater stater,
        final PrefixedLogger logger)
    {
        super(hostConfig, dnsConfig, stater, logger);

        this.hostConfig = hostConfig;
    }
    // CSON: ParameterNumber

    protected CloseableHttpResponse execute(final HttpRequest request)
        throws IOException
    {
        return this.execute(hostConfig.host(), request);
    }

    public List<OffsetInfo> offsets(
        final String clientId,
        final String topic)
        throws LogbrockerClientException
    {
        return this.offsets(hostConfig.host(), clientId, topic);
    }

    protected List<Map<String, String>> offsetsList(
        final String clientId,
        final String topic)
        throws LogbrockerClientException
    {
        return this.offsetsList(hostConfig.host(), clientId, topic);
    }

    public List<String> list(
        final String ident,
        final String logType)
        throws LogbrockerClientException
    {
        return this.list(hostConfig.host(), ident, logType);
    }

    public ImmutableHttpHostConfig hostConfig() {
        return hostConfig;
    }
}
