package ru.yandex.logbroker.client.exception;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;

import ru.yandex.http.util.BadResponseException;

public class LogbrokerBadResponseException extends LogbrockerClientException {
    private static final long serialVersionUID = -3969478218858088438L;

    private final BadResponseException wrapped;

    public LogbrokerBadResponseException(
        final Object request,
        final HttpResponse response) throws HttpException, IOException
    {
        super(request.toString());
        this.wrapped = new BadResponseException(request, response);
    }

    public LogbrokerBadResponseException(final BadResponseException bre) {
        super("Bad Response");
        this.wrapped = bre;
    }

    public LogbrokerBadResponseException(
        final Object request,
        final HttpResponse response,
        final String body)
    {
        super(request.toString());
        this.wrapped = new BadResponseException(request, response, body);
    }

    @Override
    public String getMessage() {
        return this.wrapped.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.wrapped.getLocalizedMessage();
    }
}
