package ru.yandex.logbroker.client.exception;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

import ru.yandex.http.util.BadResponseException;
import ru.yandex.util.string.StringUtils;

/**
 * Differs from BadResponseException. Should be thrown when answer is ok,
 * but contains not valid information
 */
public class LogbrokerInvalidResponseException
    extends BadResponseException
{
    private static final long serialVersionUID = -2073377870536984379L;
    private final String message;

    public LogbrokerInvalidResponseException(
        final String message,
        final HttpRequest request,
        final HttpResponse response) throws HttpException, IOException
    {
        super(request, response);
        this.message = message;
    }

    @Override
    public String getMessage() {
        return StringUtils.concat(message, ":", super.getMessage());
    }
}
