package ru.yandex.logbroker.config;

import ru.yandex.http.config.HttpTargetConfig;

public interface ClientConfig {
    String clientId();

    HttpTargetConfig sessionHttpConfig();

    /**
     * Number of workers will be laucnhed by each instance for
     * this topic.
     *
     * @return
     */
    int workers();

    String format();

    String encoding();

    int commitInterval();

    long sessionTimeout();

    /**
     * When some records failed to be consumed, we could skip some
     * records due to smth
     * @return
     */
    int maximumSkipRecordThreshold();

    /**
     * Retry delay after fail of session get attempt
     * @return session retry delay in mills
     */
    long sessionRetryDelay();

    /**
     * Retry delay for topic access due to no partitions
     * for topic
     * @return delay in mills
     */
    long retryNoPartitionsDelay();

    /**
     * Retry delay for topic access due to network problem
     * @return delay in mills
     */
    long networkRetryDelay();

    long topicResolveDelay();

    /**
     * Should we commit after each <link>workerBufferSize</link>
     * or just conitnue. For debug purpose.
     * @return true if we should commit
     */
    boolean commit();

    /**
     * Should we lock partition on logbroker read
     * @return noblock
     */
    boolean nolock();

    boolean waitData();

    /**
     * Limit number of chunks, read from topic
     * @return chunks limit
     *
     */
    int limitRecords();

    /**
     * timeout for waiting new data after
     * partition was exhausted
     *
     * @return
     */
    int waitTimeout();
}
