package ru.yandex.logbroker.config;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;

public class ClientConfigDefaults implements ClientConfig {
    public static final ClientConfigDefaults INSTANCE =
        new ClientConfigDefaults();

    private static final int WAIT_TIMEOUT = 5000;
    private static final int DEFAULT_LIMIT = 1000;
    private static final int MAXIMUM_SKIP_THRESHOLD = 100;
    private static final long DEFAULT_TIMEOUT = 5 * 60 * 1000;
    private static final long NETWORK_RETRY_DELAY = 500;
    private static final long SESSION_RETRY_DELAY = 500;
    private static final long NO_PARTITIONS_RETRY_DELAY = 1000;
    private static final long TOPIC_RESOLVE_INTERVAL = 200000;
    private static final int SESSION_TIMEOUT = 10000;
    private static final HttpTargetConfig DEFAULT_SESSION =
        new HttpTargetConfigBuilder().connections(1).timeout(SESSION_TIMEOUT);

    @Override
    public String clientId() {
        return null;
    }

    @Override
    public HttpTargetConfig sessionHttpConfig() {
        return DEFAULT_SESSION;
    }

    @Override
    public int workers() {
        return 1;
    }

    @Override
    public String format() {
        return "raw";
    }

    @Override
    public String encoding() {
        return "identity";
    }

    @Override
    public int commitInterval() {
        return 2;
    }

    @Override
    public long sessionTimeout() {
        return DEFAULT_TIMEOUT;
    }

    @Override
    public int maximumSkipRecordThreshold() {
        return MAXIMUM_SKIP_THRESHOLD;
    }

    @Override
    public long sessionRetryDelay() {
        return SESSION_RETRY_DELAY;
    }

    @Override
    public long retryNoPartitionsDelay() {
        return NO_PARTITIONS_RETRY_DELAY;
    }

    @Override
    public long networkRetryDelay() {
        return NETWORK_RETRY_DELAY;
    }

    @Override
    public boolean commit() {
        return true;
    }

    @Override
    public boolean nolock() {
        return false;
    }

    @Override
    public boolean waitData() {
        return true;
    }

    @Override
    public int limitRecords() {
        return DEFAULT_LIMIT;
    }

    @Override
    public int waitTimeout() {
        return WAIT_TIMEOUT;
    }

    @Override
    public long topicResolveDelay() {
        return TOPIC_RESOLVE_INTERVAL;
    }
}
