package ru.yandex.logbroker.config;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableClientConfig implements ClientConfig {
    private final String clientId;
    private final ImmutableHttpTargetConfig sessionHttpConfig;
    private final int workers;
    private final String format;
    private final String encoding;
    private final int commitInterval;
    private final long sessionTimeout;
    private final int maximumSkipRecordThreshold;
    private final long sessionRetryDelay;
    private final long retryNoPartitionsDelay;
    private final long networkRetryDelay;
    private final long topicResolveDelay;
    private final boolean commit;
    private final boolean waitData;
    private final boolean noLock;
    private final int limitRecords;
    private final int waitTimeout;

    public ImmutableClientConfig(final ClientConfig config)
        throws ConfigException
    {
        this.clientId = config.clientId();
        this.sessionHttpConfig =
            new ImmutableHttpTargetConfig(config.sessionHttpConfig());
        this.workers = config.workers();
        this.format = config.format();
        this.encoding = config.encoding();
        this.commitInterval = config.commitInterval();
        this.sessionTimeout = config.sessionTimeout();
        this.maximumSkipRecordThreshold = config.maximumSkipRecordThreshold();
        this.sessionRetryDelay = config.sessionRetryDelay();
        this.commit = config.commit();
        this.limitRecords = config.limitRecords();
        this.waitTimeout = config.waitTimeout();
        this.retryNoPartitionsDelay = config.retryNoPartitionsDelay();
        this.networkRetryDelay = config.networkRetryDelay();
        this.waitData = config.waitData();
        this.noLock = config.nolock();
        this.topicResolveDelay = config.topicResolveDelay();
    }

    @Override
    public String clientId() {
        return clientId;
    }

    @Override
    public ImmutableHttpTargetConfig sessionHttpConfig() {
        return sessionHttpConfig;
    }

    @Override
    public int workers() {
        return workers;
    }

    @Override
    public String format() {
        return format;
    }

    @Override
    public String encoding() {
        return encoding;
    }

    @Override
    public int commitInterval() {
        return commitInterval;
    }

    @Override
    public long sessionTimeout() {
        return sessionTimeout;
    }

    @Override
    public int maximumSkipRecordThreshold() {
        return maximumSkipRecordThreshold;
    }

    @Override
    public long sessionRetryDelay() {
        return sessionRetryDelay;
    }

    @Override
    public boolean commit() {
        return commit;
    }

    @Override
    public int limitRecords() {
        return limitRecords;
    }

    @Override
    public int waitTimeout() {
        return waitTimeout;
    }

    @Override
    public long retryNoPartitionsDelay() {
        return retryNoPartitionsDelay;
    }

    @Override
    public long networkRetryDelay() {
        return networkRetryDelay;
    }

    @Override
    public boolean nolock() {
        return noLock;
    }

    @Override
    public boolean waitData() {
        return waitData;
    }

    @Override
    public long topicResolveDelay() {
        return topicResolveDelay;
    }
}
