package ru.yandex.logbroker.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.logbroker.log.consumer.LogConsumerFactoryType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ImmutableLogConfig implements LogConfig {
    private final ImmutableClientConfig clientConfig;
    private final LogConsumerFactoryType consumerFactory;
    private final IniConfig consumerFactorySection;
    private final Map<String, List<String>> consumeMap;
    private final int parserThreads;
    private final int queueSize;
    private final String topic;
    private final String name;
    private final String ident;
    private final String logType;
    private final boolean enabled;
    private final long dcUpdatePeriod;
    private final long metricsTimeFrame;

    public ImmutableLogConfig(final LogConfig config) throws ConfigException {
        this.name = config.name();
        this.clientConfig = new ImmutableClientConfig(config.clientConfig());
        this.consumerFactory = config.consumerFactory();
        this.consumerFactorySection = config.consumerFactorySection();
        this.consumeMap =
            Collections.unmodifiableMap(new HashMap<>(config.consumeMap()));
        this.topic = config.topic();
        this.logType = config.logType();
        this.enabled = config.enabled();
        this.ident = config.ident();
        this.parserThreads = config.parserThreads();
        this.queueSize = config.queueSize();
        this.dcUpdatePeriod = config.dcUpdatePeriod();
        this.metricsTimeFrame = config.metricsTimeFrame();

        if (topic == null && (ident == null || logType == null)) {
            throw new ConfigException(
                "Topic or ident + logType should be specified");
        }
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public ImmutableClientConfig clientConfig() {
        return clientConfig;
    }

    @Override
    public LogConsumerFactoryType consumerFactory() {
        return consumerFactory;
    }

    @Override
    public IniConfig consumerFactorySection() {
        return consumerFactorySection;
    }

    @Override
    public Map<String, List<String>> consumeMap() {
        return consumeMap;
    }

    @Override
    public String topic() {
        return topic;
    }

    @Override
    public String ident() {
        return ident;
    }

    @Override
    public String logType() {
        return logType;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public int parserThreads() {
        return parserThreads;
    }

    @Override
    public int queueSize() {
        return queueSize;
    }

    @Override
    public long dcUpdatePeriod() {
        return dcUpdatePeriod;
    }

    @Override
    public long metricsTimeFrame() {
        return metricsTimeFrame;
    }
}
