package ru.yandex.logbroker.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLogbrokerConsumerConfig
    implements LogbrokerConsumerConfig
{
    private final ImmutableHttpHostConfig logbrokerHostConfig;
    private final String dc;
    private final String dumpJsonPath;
    private final long stopWaitTimeout;
    private final Map<String, ImmutableLogConfig> logConfig;

    public ImmutableLogbrokerConsumerConfig(
        final LogbrokerConsumerConfig config)
        throws ConfigException
    {
        this.logbrokerHostConfig =
            new ImmutableHttpHostConfig(config.logbrokerHostConfig());
        this.dc = config.dc();
        this.dumpJsonPath = config.dumpJsonPath();
        Map<String, ImmutableLogConfig> logConfig = new HashMap<>();
        for (Map.Entry<String, ? extends LogConfig> entry
            : config.logConfig().entrySet())
        {
            logConfig.put(
                entry.getKey(),
                new ImmutableLogConfig(entry.getValue()));
        }

        this.logConfig = Collections.unmodifiableMap(logConfig);
        this.stopWaitTimeout = config.stopWaitTimeout();
        if (this.dc == null && this.dumpJsonPath == null) {
            throw new ConfigException("No dc or dumpjsonpath specified");
        }
    }

    @Override
    public ImmutableHttpHostConfig logbrokerHostConfig() {
        return logbrokerHostConfig;
    }

    @Override
    public String dc() {
        return dc;
    }

    @Override
    public String dumpJsonPath() {
        return dumpJsonPath;
    }

    @Override
    public Map<String, ImmutableLogConfig> logConfig() {
        return logConfig;
    }

    @Override
    public long stopWaitTimeout() {
        return stopWaitTimeout;
    }
}
