package ru.yandex.logbroker.config;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLogbrokerConsumerServerConfig
    extends ImmutableHttpProxyConfig
    implements LogbrokerConsumerServerConfig
{
    private final ImmutableLogbrokerConsumerConfig consumerConfig;

    public ImmutableLogbrokerConsumerServerConfig(
        final LogbrokerConsumerServerConfig config)
        throws ConfigException
    {
        super(config);

        this.consumerConfig =
            new ImmutableLogbrokerConsumerConfig(config.consumerConfig());
    }

    @Override
    public ImmutableLogbrokerConsumerConfig consumerConfig() {
        return consumerConfig;
    }
}
