package ru.yandex.logbroker.config;

import ru.yandex.logbroker.client.AuthorizedLogbrokerClient;
import ru.yandex.logbroker.topic.ChunkConsumer;
import ru.yandex.logger.PrefixedLogger;

public class ImmutableTopicConfig implements TopicConfig {
    private final TopicClientConfig clientConfig;
    private final String dc;
    private final String logName;
    private final String topic;
    private final AuthorizedLogbrokerClient client;
    private final PrefixedLogger logger;
    private final ChunkConsumer consumer;
    private final ThreadGroup threadGroup;

    public ImmutableTopicConfig(final TopicConfig config) {
        this.clientConfig =
            new TopicClientConfig(
                config.config().hostConfig(),
                config.config().clientConfig());

        this.dc = config.dc();
        this.logName = config.logName();
        this.client = config.client();
        this.logger = config.logger();
        this.consumer = config.consumer();
        this.topic = config.topic();
        this.threadGroup = config.threadGroup();
    }

    @Override
    public TopicClientConfig config() {
        return clientConfig;
    }

    @Override
    public String dc() {
        return dc;
    }

    @Override
    public String logName() {
        return logName;
    }

    @Override
    public AuthorizedLogbrokerClient client() {
        return client;
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    @Override
    public ChunkConsumer consumer() {
        return consumer;
    }

    @Override
    public String topic() {
        return topic;
    }

    @Override
    public ThreadGroup threadGroup() {
        return threadGroup;
    }
}
