package ru.yandex.logbroker.config;

import java.util.List;
import java.util.Map;

import ru.yandex.logbroker.log.consumer.LogConsumerFactoryType;
import ru.yandex.parser.config.IniConfig;

public interface LogConfig {
    String name();

    ClientConfig clientConfig();

    LogConsumerFactoryType consumerFactory();

    IniConfig consumerFactorySection();

    Map<String, List<String>> consumeMap();

    /**
     * Topic to consume
     * @return topic
     */
    String topic();

    String ident();

    String logType();

    boolean enabled();

    int parserThreads();

    int queueSize();

    /**
     * Time in milliseconds between update of available dcs for log
     * @return
     */
    long dcUpdatePeriod();

    long metricsTimeFrame();
}
