package ru.yandex.logbroker.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.logbroker.log.consumer.LogConsumerFactoryType;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.stater.StaterConfigDefaults;

public class LogConfigDefaults implements LogConfig {
    public static final LogConfigDefaults INSTANCE = new LogConfigDefaults();
    private static final long DEFAULT_DC_UPDATE_INTERVAL = 200000;

    @Override
    public String name() {
        return null;
    }

    @Override
    public ClientConfig clientConfig() {
        return ClientConfigDefaults.INSTANCE;
    }

    @Override
    public LogConsumerFactoryType consumerFactory() {
        return LogConsumerFactoryType.DEV_NULL_LOG;
    }

    @Override
    public IniConfig consumerFactorySection() {
        return null;
    }

    @Override
    public Map<String, List<String>> consumeMap() {
        return Collections.emptyMap();
    }

    @Override
    public String topic() {
        return null;
    }

    @Override
    public String ident() {
        return null;
    }

    @Override
    public String logType() {
        return null;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public int parserThreads() {
        return 1;
    }

    @Override
    public int queueSize() {
        return 1;
    }

    @Override
    public long dcUpdatePeriod() {
        return DEFAULT_DC_UPDATE_INTERVAL;
    }

    @Override
    public long metricsTimeFrame() {
        return StaterConfigDefaults.INSTANCE.metricsTimeFrame();
    }
}
