package ru.yandex.logbroker.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class LogbrokerConsumerConfigBuilder
    implements LogbrokerConsumerConfig
{
    private HttpHostConfigBuilder logbrokerHostConfig;
    private String dumpJsonPath;
    private String dc;
    private long stopWaitTimeout;
    private Map<String, LogConfigBuilder> logConfig;

    public LogbrokerConsumerConfigBuilder() {
        this(LogbrokerConsumerConfigDefaults.INSTANCE);
    }

    public LogbrokerConsumerConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, LogbrokerConsumerConfigDefaults.INSTANCE);
    }

    public LogbrokerConsumerConfigBuilder(
        final LogbrokerConsumerConfig config)
    {
        this.logbrokerHostConfig(config.logbrokerHostConfig());
        this.dumpJsonPath(config.dumpJsonPath());
        this.dc(config.dc());
        this.logConfig(config.logConfig());
    }

    public LogbrokerConsumerConfigBuilder(
        final IniConfig config,
        final LogbrokerConsumerConfig defaults)
        throws ConfigException
    {
        this.logbrokerHostConfig =
            new HttpHostConfigBuilder(
                config.section("logbroker"),
                defaults.logbrokerHostConfig());
        this.stopWaitTimeout =
            config.getLong("stop-timeout", defaults.stopWaitTimeout());

        IniConfig logSection = config.section("topic");
        this.logConfig = new HashMap<>();
        for (Map.Entry<String, IniConfig> entry
            : logSection.sections().entrySet())
        {
            this.logConfig.put(
                entry.getKey(),
                new LogConfigBuilder(entry.getKey(), entry.getValue()));
        }

        dc = config.getString("dc", null);
        dumpJsonPath = config.getString("dump-json", null);
    }

    @Override
    public HttpHostConfigBuilder logbrokerHostConfig() {
        return logbrokerHostConfig;
    }

    public LogbrokerConsumerConfigBuilder logbrokerHostConfig(
        final HttpHostConfig logbrokerHostConfig)
    {
        this.logbrokerHostConfig =
            new HttpHostConfigBuilder(logbrokerHostConfig);

        return this;
    }

    @Override
    public String dumpJsonPath() {
        return dumpJsonPath;
    }

    public LogbrokerConsumerConfigBuilder dumpJsonPath(
        final String dumpJsonPath)
    {
        this.dumpJsonPath = dumpJsonPath;
        return this;
    }

    @Override
    public Map<String, LogConfigBuilder> logConfig() {
        return logConfig;
    }

    public LogbrokerConsumerConfigBuilder logConfig(
        final Map<String, ? extends LogConfig> logConfig)
    {
        this.logConfig = new HashMap<>();
        logConfig.forEach(
            (k, v) -> this.logConfig.put(k, new LogConfigBuilder(v)));

        return this;
    }

    @Override
    public String dc() {
        return dc;
    }

    public LogbrokerConsumerConfigBuilder dc(final String dc) {
        this.dc = dc;
        return this;
    }

    public ImmutableLogbrokerConsumerConfig build() throws ConfigException {
        return new ImmutableLogbrokerConsumerConfig(this);
    }

    @Override
    public long stopWaitTimeout() {
        return stopWaitTimeout;
    }

    public LogbrokerConsumerConfigBuilder stopWaitTimeout(final long to) {
        this.stopWaitTimeout = to;
        return this;
    }
}
