package ru.yandex.logbroker.config;

import java.util.Collections;
import java.util.Map;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;

public class LogbrokerConsumerConfigDefaults
    implements LogbrokerConsumerConfig
{
    public static final LogbrokerConsumerConfigDefaults INSTANCE =
        new LogbrokerConsumerConfigDefaults();

    // 10 min
    private static final long DEFAULT_WAIT_TIMEOUT = 10 * 60 * 1000;

    @Override
    public HttpHostConfig logbrokerHostConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String dumpJsonPath() {
        return null;
    }

    @Override
    public String dc() {
        return null;
    }

    @Override
    public Map<String, ? extends LogConfig> logConfig() {
        return Collections.emptyMap();
    }

    @Override
    public long stopWaitTimeout() {
        return DEFAULT_WAIT_TIMEOUT;
    }
}
