package ru.yandex.logbroker.config;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class LogbrokerConsumerServerConfigBuilder
    extends
    AbstractHttpProxyConfigBuilder<LogbrokerConsumerServerConfigBuilder>
    implements LogbrokerConsumerServerConfig
{
    private LogbrokerConsumerConfigBuilder consumerConfig;

    public LogbrokerConsumerServerConfigBuilder() {
        this(LogbrokerConsumerServerConfigDefaults.INSTANCE);
    }

    public LogbrokerConsumerServerConfigBuilder(
        final LogbrokerConsumerServerConfig config)
    {
        super(config);

        consumerConfig(config.consumerConfig());
    }

    public LogbrokerConsumerServerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, LogbrokerConsumerServerConfigDefaults.INSTANCE);
    }

    public LogbrokerConsumerServerConfigBuilder(
        final IniConfig config,
        final LogbrokerConsumerServerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        this.consumerConfig =
            new LogbrokerConsumerConfigBuilder(
                config,
                defaults.consumerConfig());
    }

    @Override
    public LogbrokerConsumerServerConfigBuilder self() {
        return this;
    }

    public ImmutableLogbrokerConsumerServerConfig build()
        throws ConfigException
    {
        return new ImmutableLogbrokerConsumerServerConfig(this);
    }

    @Override
    public LogbrokerConsumerConfigBuilder consumerConfig() {
        return consumerConfig;
    }

    public LogbrokerConsumerServerConfigBuilder consumerConfig(
        final LogbrokerConsumerConfig consumerConfig)
    {
        this.consumerConfig =
            new LogbrokerConsumerConfigBuilder(consumerConfig);
        return self();
    }
}
