package ru.yandex.logbroker.config;

import ru.yandex.logbroker.client.AuthorizedLogbrokerClient;
import ru.yandex.logbroker.topic.ChunkConsumer;
import ru.yandex.logger.PrefixedLogger;

public class TopicConfigBuilder implements TopicConfig {
    private TopicClientConfig clientConfig;
    private String dc;
    private String logName;
    private String topic;
    private AuthorizedLogbrokerClient client;
    private PrefixedLogger logger;
    private ChunkConsumer consumer;
    private ThreadGroup threadGroup;

    public TopicConfigBuilder() {
    }

    public TopicConfigBuilder(final TopicConfig config) {
        this.config(config.config());
        this.dc(config.dc());
        this.logName(config.logName());
        this.client(config.client());
        this.logger(config.logger());
        this.consumer(config.consumer());
        this.threadGroup(config.threadGroup());
    }

    @Override
    public TopicClientConfig config() {
        return clientConfig;
    }

    public TopicConfigBuilder config(final TopicClientConfig config) {
        this.clientConfig = config;
        return this;
    }

    @Override
    public String dc() {
        return dc;
    }

    public TopicConfigBuilder dc(final String dc) {
        this.dc = dc;
        return this;
    }

    @Override
    public String logName() {
        return logName;
    }

    public TopicConfigBuilder logName(final String logName) {
        this.logName = logName;
        return this;
    }

    @Override
    public AuthorizedLogbrokerClient client() {
        return client;
    }

    public TopicConfigBuilder client(
        final AuthorizedLogbrokerClient client)
    {
        this.client = client;
        return this;
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    public TopicConfigBuilder logger(final PrefixedLogger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public ChunkConsumer consumer() {
        return consumer;
    }

    public TopicConfigBuilder consumer(
        final ChunkConsumer consumer)
    {
        this.consumer = consumer;
        return this;
    }

    public ImmutableTopicConfig build() {
        return new ImmutableTopicConfig(this);
    }

    @Override
    public String topic() {
        return topic;
    }

    public TopicConfigBuilder topic(final String topic) {
        this.topic = topic;
        return this;
    }

    @Override
    public ThreadGroup threadGroup() {
        return threadGroup;
    }

    public TopicConfigBuilder threadGroup(final ThreadGroup group) {
        this.threadGroup = group;
        return this;
    }
}
