package ru.yandex.logbroker.config.blackbox;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;

public class ImmutableOnlineUsersStorageConfig
    extends ImmutableHttpTargetConfig
    implements OnlineUsersStorageConfig
{
    private final ImmutableSearchMapConfig searchmap;

    public ImmutableOnlineUsersStorageConfig(
        final OnlineUsersStorageConfig config)
        throws ConfigException
    {
        super(config);

        this.searchmap = new ImmutableSearchMapConfig(config.searchmap());
    }

    @Override
    public ImmutableSearchMapConfig searchmap() {
        return searchmap;
    }
}
