package ru.yandex.logbroker.config.blackbox;

import ru.yandex.http.config.AbstractHttpTargetConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigBuilder;

public class OnlineUsersStorageConfigBuilder
    extends AbstractHttpTargetConfigBuilder<OnlineUsersStorageConfigBuilder>
    implements OnlineUsersStorageConfig
{
    private SearchMapConfigBuilder searchmap;

    public OnlineUsersStorageConfigBuilder() {
        this(OnlineUsersStorageConfigDefaults.INSTANCE);
    }

    public OnlineUsersStorageConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, OnlineUsersStorageConfigDefaults.INSTANCE);
    }

    public OnlineUsersStorageConfigBuilder(
        final OnlineUsersStorageConfig config)
    {
        super(config);

        this.searchmap(config.searchmap());
    }

    public OnlineUsersStorageConfigBuilder(
        final IniConfig config,
        final OnlineUsersStorageConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        IniConfig searchmapSection = config.section("majormap");
        this.searchmap =
            new SearchMapConfigBuilder(searchmapSection, defaults.searchmap());
        String searchmapContent = searchmapSection.getOrNull("content");
        if (searchmapContent != null) {
            this.searchmap.content(searchmapContent);
        }
    }

    @Override
    public OnlineUsersStorageConfigBuilder self() {
        return this;
    }

    public ImmutableOnlineUsersStorageConfig build() throws ConfigException {
        return new ImmutableOnlineUsersStorageConfig(this);
    }

    @Override
    public SearchMapConfigBuilder searchmap() {
        return searchmap;
    }

    public OnlineUsersStorageConfigBuilder searchmap(
        final SearchMapConfig searchmap)
    {
        this.searchmap = new SearchMapConfigBuilder(searchmap);
        return this;
    }
}
