package ru.yandex.logbroker.config.integration;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractClickIndexerConfigBuilder<T>
    implements ClickIndexerConfig
{
    private boolean enabled;
    private String pgQueue;
    private String pgCorpQueue;
    private String indexUri;

    protected AbstractClickIndexerConfigBuilder(
        final IniConfig config,
        final ClickIndexerConfig defaults)
        throws ConfigException
    {
        enabled = config.getBoolean("enabled", defaults.enabled());
        pgQueue = config.getString("bp-queue", defaults.pgQueue());
        pgCorpQueue = config.getString("corp-queue", defaults.pgCorpQueue());
        indexUri = config.getString("indexUri", defaults.indexUri());
    }

    protected AbstractClickIndexerConfigBuilder(final ClickIndexerConfig config) {
        enabled = config.enabled();
        pgQueue = config.pgQueue();
        pgCorpQueue = config.pgCorpQueue();
        indexUri = config.indexUri();
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    public T enabled(final boolean enabled) {
        this.enabled = enabled;
        return self();
    }

    @Override
    public String pgCorpQueue() {
        return pgCorpQueue;
    }

    public T pgCorpQueue(final String pgCorpQueue) {
        this.pgCorpQueue = pgCorpQueue;
        return self();
    }

    @Override
    public String pgQueue() {
        return pgQueue;
    }

    public T pgQueue(final String pgQueue) {
        this.pgQueue = pgQueue;
        return self();
    }

    @Override
    public String indexUri() {
        return indexUri;
    }

    public T indexUri(final String uri) {
        this.indexUri = uri;
        return self();
    }

    protected abstract T self();
}
