package ru.yandex.logbroker.config.integration;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ClickIndexerConfigBuilder
    extends AbstractClickIndexerConfigBuilder<ClickIndexerConfigBuilder>
{
    public ClickIndexerConfigBuilder() {
        super(ClickIndexerConfigDefaults.INSTANCE);
    }

    public ClickIndexerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ClickIndexerConfigDefaults.INSTANCE);
    }

    public ClickIndexerConfigBuilder(
        final IniConfig config,
        final ClickIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ClickIndexerConfigBuilder(final ClickIndexerConfig config) {
        super(config);
    }

    @Override
    public ClickIndexerConfigBuilder self() {
        return this;
    }

    public ImmutableClickIndexerConfig build() throws ConfigException {
        return new ImmutableClickIndexerConfig(this);
    }
}
