package ru.yandex.logbroker.config.integration;

import ru.yandex.http.config.HttpHostConfigDefaults;

public class ClickIndexerConfigDefaults
    extends HttpHostConfigDefaults
    implements ClickIndexerConfig
{
    public static final ClickIndexerConfigDefaults INSTANCE =
        new ClickIndexerConfigDefaults();

    private static final boolean DEFAULT_ENABLED = true;
    private static final String PG_CORP_QUEUE = "corp_change_log";
    private static final String PG_QUEUE = "change_log";
    private static final String INDEX_URI = "/notify?";

    @Override
    public boolean enabled() {
        return DEFAULT_ENABLED;
    }

    @Override
    public String pgCorpQueue() {
        return PG_CORP_QUEUE;
    }

    @Override
    public String pgQueue() {
        return PG_QUEUE;
    }

    @Override
    public String indexUri() {
        return INDEX_URI;
    }
}
