package ru.yandex.logbroker.config.integration;

import ru.yandex.parser.config.ConfigException;

public class ImmutableClickIndexerConfig implements ClickIndexerConfig {
    private final boolean enabled;
    private final String pgCorpQueue;
    private final String pgQueue;
    private final String indexUri;

    public ImmutableClickIndexerConfig(final ClickIndexerConfig config)
        throws ConfigException
    {
        this.enabled = config.enabled();
        this.pgCorpQueue = config.pgCorpQueue();
        this.pgQueue = config.pgQueue();
        this.indexUri = config.indexUri();
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public String pgCorpQueue() {
        return pgCorpQueue;
    }

    @Override
    public String pgQueue() {
        return pgQueue;
    }

    @Override
    public String indexUri() {
        return indexUri;
    }
}
