package ru.yandex.logbroker.log;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.logbroker.LagsStater;
import ru.yandex.stater.AbstractStatable;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class ParseMetrics extends AbstractStatable {
    private static final int[] TIME_LAG_BOUNDARIES =
        new int[] {1001, 2001, 3001, 5001, 10001, 30001, 60001};
    private static final int[] PARSE_TIME_BOUNDARIES =
        new int[] {10, 100, 300, 500};
    private static final int[] CONSUME_TIME_BOUNDARIES =
        new int[] {10, 100, 300, 500, 1000, 3000};
    private static final int[] DELIVERY_BOUNDARIES =
        new int[] {100, 300, 500, 800, 1000, 1500, 2000};
    private static final int[] WAITLOG_BOUNDARIES =
        new int[] {250, 500, 750, 1000, 1250, 1500, 1750, 2000, 2250, 2500,
            2750, 3000, 3250, 3500, 3750, 4000};

    private TimeFrameQueue<Long> parseErrorsFrame;
    private TimeFrameQueue<Long> consumeErrorsFrame;
    private TimeFrameQueue<Long> recordsParsedFrame;
    private TimeFrameQueue<Long> consumeTimesFrame;
    private TimeFrameQueue<Long> parseTimesFrame;
    private TimeFrameQueue<Long> timelagFrame;
    private TimeFrameQueue<Long> logbrokerDelivery;
    private TimeFrameQueue<Long> blackboxWaittime;

    public ParseMetrics(final String log, final long frame) {
        this.parseErrorsFrame = new TimeFrameQueue<>(frame);
        this.consumeErrorsFrame = new TimeFrameQueue<>(frame);
        this.recordsParsedFrame = new TimeFrameQueue<>(frame);
        this.consumeTimesFrame = new TimeFrameQueue<>(frame);
        this.parseTimesFrame = new TimeFrameQueue<>(frame);
        this.timelagFrame = new TimeFrameQueue<>(frame);
        this.logbrokerDelivery = new TimeFrameQueue<>(frame);
        this.blackboxWaittime = new TimeFrameQueue<>(frame);

        final String prefix = log + "-parser";
        this.registerStater(
            new PassiveStaterAdapter<>(
                parseErrorsFrame,
                new NamedStatsAggregatorFactory<>(
                    prefix + "-errors_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));

        this.registerStater(
            new PassiveStaterAdapter<>(
                recordsParsedFrame,
                new NamedStatsAggregatorFactory<>(
                    prefix + "-records_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));

        this.registerStater(
            new PassiveStaterAdapter<>(
                consumeErrorsFrame,
                new NamedStatsAggregatorFactory<>(
                    log + "-records-consume-failed_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));

        this.registerStater(
            new LagsStater(
                consumeTimesFrame,
                prefix + "-consume",
                CONSUME_TIME_BOUNDARIES));
        this.registerStater(
            new LagsStater(
                parseTimesFrame,
                prefix + "-parse",
                PARSE_TIME_BOUNDARIES));
        this.registerStater(
            new LagsStater(timelagFrame, prefix + "-lag", TIME_LAG_BOUNDARIES));

        this.registerStater(
            new LagsStater(
                logbrokerDelivery,
                prefix + "-delivery-lag",
                DELIVERY_BOUNDARIES));

        this.registerStater(
            new LagsStater(
                blackboxWaittime,
                prefix + "-waitlog-times",
                WAITLOG_BOUNDARIES));
    }

    public void timeLag(final long ts) {
        timelagFrame.accept(ts);
    }

    public void logbrokerDelivery(final long time) {
        logbrokerDelivery.accept(time);
    }

    public void logbrokerWaitlog(final long time) {
        blackboxWaittime.accept(time);
    }

    public void recordParsed() {
        recordsParsedFrame.accept(1L);
    }

    public void parseError() {
        parseErrorsFrame.accept(1L);
    }

    public void consumeTime(final long ts) {
        consumeTimesFrame.accept(ts);
    }

    public void parseTime(final long ts) {
        parseTimesFrame.accept(ts);
    }

    public void consumeError() {
        consumeErrorsFrame.accept(1L);
    }
}
