package ru.yandex.logbroker.log;

import java.io.IOException;
import java.io.Reader;

import ru.yandex.logbroker.LogbrokerInplaceTskvParser;
import ru.yandex.logbroker.log.consumer.ChunkProducer;
import ru.yandex.logbroker.log.consumer.LogConsumer;
import ru.yandex.logbroker.topic.DataChunk;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.tskv.TskvException;

public class TskvLogParser extends AbstractLogParser<LogbrokerTskvRecord> {
    //CSOFF: ParameterNumber
    public TskvLogParser(
        final ChunkProducer chunkProducer,
        final LogConsumer<LogbrokerTskvRecord> consumer,
        final ParseMetrics metrics,
        final PrefixedLogger logger)
    {
        super(chunkProducer, consumer, metrics, logger);
    }

    public TskvLogParser(
        final ChunkProducer chunkProducer,
        final LogConsumer<LogbrokerTskvRecord> consumer,
        final ParseMetrics metrics,
        final PrefixedLogger logger,
        final boolean waitConsume)
    {
        super(chunkProducer, consumer, metrics, logger, waitConsume);
    }
    //CSON: ParameterNumber

    @Override
    public long process(
        final Reader reader,
        final DataChunk chunk,
        final ChunkConsumeCallback callback)
        throws TskvException, IOException
    {
        long parseTime = 0;
        LogbrokerInplaceTskvParser parser =
            new LogbrokerInplaceTskvParser();

        long ts = System.currentTimeMillis();
        LogbrokerTskvRecord record = parser.next(reader);
        while (record != null) {
            parseTime += System.currentTimeMillis() - ts;

            metrics.recordParsed();
            metrics.logbrokerWaitlog(
                chunk.createTime() - record.unixtime() * THOUSAND);

            callback.sent();
            consumer.apply(record, callback);

            metrics.timeLag(
                System.currentTimeMillis()
                    - record.unixtime() * THOUSAND);

            ts = System.currentTimeMillis();
            record = parser.next(reader);
        }

        return parseTime;
    }
}
