package ru.yandex.logbroker.log;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

import ru.yandex.stater.PassiveStater;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class UnitedLagStater implements Stater {
    private final ConcurrentHashMap<String, Iterable<Long>> map
        = new ConcurrentHashMap<>();
    private final Supplier<? extends PassiveStater<Long>> statersFactory;

    public UnitedLagStater(
        final Supplier<? extends PassiveStater<Long>> statersFactory)
    {
        this.statersFactory = statersFactory;
    }

    public void add(
        final String name,
        final Iterable<Long> data)
    {
        map.put(name, data);
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        PassiveStater<Long> stater = statersFactory.get();
        for (Iterable<Long> data: map.values()) {
            for (Long value: data) {
                stater.accept(value);
            }
        }

        stater.stats(statsConsumer);
    }
}
