package ru.yandex.logbroker.log.consumer;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.logbroker.config.LogConfig;
import ru.yandex.logbroker.log.LogbrokerTskvRecord;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.stater.StatsConsumer;

public class DevNullLogConsumerFactory implements TskvLogConsumerFactory {
    public static final DevNullLogConsumerFactory INSTANCE =
        new DevNullLogConsumerFactory();

    @Override
    public LogConsumer<LogbrokerTskvRecord> create(
        final LogConfig logConfig,
        final PrefixedLogger logger)
    {
        return new DevNullLogConsumer();
    }

    private static final class DevNullLogConsumer
        implements LogConsumer<LogbrokerTskvRecord>
    {
        private DevNullLogConsumer() {
        }

        @Override
        public void apply(
            final LogbrokerTskvRecord record,
            final FutureCallback<Object> callback)
        {
            callback.completed(null);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
    }

    @Override
    public String name() {
        return "devnull";
    }

    @Override
    public Map<String, Object> status(final boolean verbose) {
        return Collections.emptyMap();
    }
}
