package ru.yandex.logbroker.log.consumer;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.logbroker.config.LogConfig;
import ru.yandex.logbroker.log.JsonLogParser;
import ru.yandex.logbroker.log.LogParser;
import ru.yandex.logbroker.log.ParseMetrics;
import ru.yandex.logger.PrefixedLogger;

public interface JsonLogConsumerFactory extends LogConsumerFactory {
    //CSOFF: ParameterNumber
    @Override
    default LogParser create(
        final LogConfig config,
        final ChunksQueue queue,
        final ParseMetrics metrics,
        final PrefixedLogger logger)
    {
        return new JsonLogParser(
            queue,
            create(config, logger),
            metrics,
            logger);
    }
    //CSON: ParameterNumber

    LogConsumer<JsonMap> create(
        final LogConfig config,
        final PrefixedLogger logger);
}
