package ru.yandex.logbroker.log.consumer;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.logbroker.topic.DataChunk;

public interface LogConsumer<T> {
    void apply(
        final T record,
        final FutureCallback<Object> callback);

    default void batchStart(final DataChunk chunk) {
        batchStart();
    }

    default void batchStart() {
    }

    default void batchEnd(final FutureCallback<Object> callback) {
        callback.completed(null);
    }
}
