package ru.yandex.logbroker.log.consumer;

import java.io.IOException;
import java.util.Map;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.logbroker.config.LogConfig;
import ru.yandex.logbroker.log.LogParser;
import ru.yandex.logbroker.log.ParseMetrics;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.stater.Stater;

public interface LogConsumerFactory
    extends Stater, GenericAutoCloseable<IOException>
{
    //CSOFF: ParameterNumber
    LogParser create(
        final LogConfig config,
        final ChunksQueue queue,
        final ParseMetrics metrics,
        final PrefixedLogger logger);
    //CSON: ParameterNumber

    String name();

    Map<String, Object> status(final boolean verbose);
}
