package ru.yandex.logbroker.log.consumer;

import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.logbroker.config.ImmutableLogbrokerConsumerServerConfig;
import ru.yandex.logbroker.log.consumer.blackbox.BlackboxLogConsumerFactory;
import ru.yandex.logbroker.log.consumer.integration.IntegrationLogConsumerFactory;
import ru.yandex.logbroker.log.consumer.sherlock.SherlockTemplatesConsumerFactory;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum LogConsumerFactoryType {
    BLACKBOX {
        @Override
        public LogConsumerFactory create(
            final SharedConnectingIOReactor reactor,
            final ImmutableLogbrokerConsumerServerConfig serverConfig,
            final IniConfig config)
            throws ConfigException
        {
            return new BlackboxLogConsumerFactory(
                reactor,
                serverConfig,
                config);
        }
    },
    INTEGRATION {
        @Override
        public LogConsumerFactory create(
            final SharedConnectingIOReactor reactor,
            final ImmutableLogbrokerConsumerServerConfig serverConfig,
            final IniConfig config)
            throws ConfigException
        {
            return new IntegrationLogConsumerFactory(
                reactor,
                serverConfig,
                config);
        }
    },
    SHERLOCK_TEMPLATES {
        @Override
        public LogConsumerFactory create(
            final SharedConnectingIOReactor reactor,
            final ImmutableLogbrokerConsumerServerConfig serverConfig,
            final IniConfig config) throws ConfigException
        {
            return new SherlockTemplatesConsumerFactory(
                reactor,
                serverConfig,
                config);
        }
    },
    POST {
        @Override
        public LogConsumerFactory create(
            final SharedConnectingIOReactor reactor,
            final ImmutableLogbrokerConsumerServerConfig serverConfig,
            final IniConfig config)
            throws ConfigException
        {
            return new HttpPostLogConsumerFactory(
                reactor,
                serverConfig,
                config);
        }
    },
    DEV_NULL_LOG {
        @Override
        public LogConsumerFactory create(
            final SharedConnectingIOReactor reactor,
            final ImmutableLogbrokerConsumerServerConfig serverConfig,
            final IniConfig config)
        {
            return new DevNullLogConsumerFactory();
        }
    };

    public abstract LogConsumerFactory create(
        final SharedConnectingIOReactor reactor,
        final ImmutableLogbrokerConsumerServerConfig serverConfig,
        final IniConfig config)
        throws ConfigException;
}
