package ru.yandex.logbroker.log.consumer;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriter;

public final class LuceneFunctions {
    private static final String FUNCTION = "function";
    private static final String ARGS = "args";
    private static final String GET = "get";

    private LuceneFunctions() {
    }

    public static void createSumMapFunction(
        final JsonWriter writer,
        final String field,
        final String map)
        throws IOException
    {
        writer.key(field);
        writer.startObject();
        writer.key(FUNCTION);
        writer.value("sum_map");
        writer.key(ARGS);
        writer.startArray();
        writer.value(map);
        writer.startObject();
        writer.key(FUNCTION);
        writer.value(GET);
        writer.key(ARGS);
        writer.startArray();
        writer.value(field);
        writer.endArray();
        writer.endObject();
        writer.endArray();
        writer.endObject();
    }

    public static void makeSetFunction(
        final JsonWriter writer,
        final String field,
        final String value)
        throws IOException
    {
        writer.key(field);
        writer.startObject();
        writer.key(FUNCTION);
        writer.value("make_set");
        writer.key(ARGS);
        writer.startArray();
        writer.value(value);
        writer.startObject();
        writer.key(FUNCTION);
        writer.value(GET);
        writer.key(ARGS);
        writer.startArray();
        writer.value(field);
        writer.endArray();
        writer.endObject();
        writer.endArray();
        writer.endObject();
    }
}
