package ru.yandex.logbroker.log.consumer;

import ru.yandex.logbroker.config.LogConfig;
import ru.yandex.logbroker.log.LogParser;
import ru.yandex.logbroker.log.LogbrokerTskvRecord;
import ru.yandex.logbroker.log.ParseMetrics;
import ru.yandex.logbroker.log.TskvLogParser;
import ru.yandex.logger.PrefixedLogger;

public interface TskvLogConsumerFactory extends LogConsumerFactory {
    //CSOFF: ParameterNumber
    @Override
    default LogParser create(
        final LogConfig config,
        final ChunksQueue queue,
        final ParseMetrics metrics,
        final PrefixedLogger logger)
    {
        return new TskvLogParser(
            queue,
            create(config, logger),
            metrics,
            logger);
    }
    //CSON: ParameterNumber

    LogConsumer<LogbrokerTskvRecord> create(
        final LogConfig config,
        final PrefixedLogger logger);
}
