package ru.yandex.logbroker.log.consumer.blackbox;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.logbroker.config.blackbox.ImmutableOnlineUsersStorageConfig;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;

public class BlackboxConsumerContext {
    private final AsyncClient userOnlineClient;
    private final ImmutableOnlineUsersStorageConfig config;
    private final PrefixedLogger logger;
    private final Map<Integer, SearchMapShard> searchmap;
    private TimeFrameQueue<Long> staleStater;
    private TimeFrameQueue<Long> parseError;

    //CSOFF: ParameterNumber
    public BlackboxConsumerContext(
        final TimeFrameQueue<Long> staleStater,
        final TimeFrameQueue<Long> parseError,
        final AsyncClient userOnlineClient,
        final ImmutableOnlineUsersStorageConfig config,
        final PrefixedLogger logger)
        throws ConfigException
    {
        this.userOnlineClient = userOnlineClient;
        this.staleStater = staleStater;
        this.parseError = parseError;

        this.config = config;
        try {
            SearchMap searchmap = config.searchmap().build();
            Map<Integer, SearchMapShard> shards = new LinkedHashMap<>();
            for (int i = 0; i < SearchMap.SHARDS_COUNT; i++) {
                shards.put(
                    i,
                    searchmap.hosts(
                        new User("major", new LongPrefix(i))));
            }

            this.searchmap = Collections.unmodifiableMap(shards);
        } catch (IOException | ParseException e) {
            throw new ConfigException("Failed to read searchmap", e);
        }

        this.logger = logger;
    }
    //CSON: ParameterNumber

    public void stale() {
        this.staleStater.accept(1L);
    }

    public void parseError() {
        this.parseError.accept(1L);
    }

    public AsyncClient client() {
        return userOnlineClient;
    }

    public PrefixedLogger logger() {
        return logger;
    }

    public ImmutableOnlineUsersStorageConfig config() {
        return config;
    }

    public Map<Integer, SearchMapShard> searchMap() {
        return searchmap;
    }

    public SearchMapShard shard(final long prefix) {
        return searchmap.get((int) (prefix % SearchMap.SHARDS_COUNT));
    }
}
