package ru.yandex.logbroker.log.consumer.blackbox;

import java.util.List;

public class SessionCheck {
    private final List<Long> uids;
    private final String host;
    private final String yuid;
    private final long ts;
    private final String userIp;

    // CSOFF: ParameterNumber
    public SessionCheck(
        final List<Long> uid,
        final String host,
        final String yuid,
        final String userIp,
        final long ts)
    {
        this.uids = uid;
        this.ts = ts;
        this.host = host;
        this.userIp = userIp;
        this.yuid = yuid;
    }
    // CSON: ParameterNumber

    public List<Long> uid() {
        return uids;
    }

    public String yuid() {
        return yuid;
    }

    public long ts() {
        return ts;
    }

    public String host() {
        return host;
    }

    public String userIp() {
        return userIp;
    }

    @Override
    public String toString() {
        return "SessionCheck{"
            + "uids=" + uids
            + ", host=" + host
            + ", ts=" + ts
            + ", ip=" + userIp
            + '}';
    }
}
