package ru.yandex.logbroker.log.consumer.integration;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;
import ru.yandex.logbroker.log.consumer.integration.click.IndexationClient;
import ru.yandex.logger.PrefixedLogger;

public class IntegrationContext {
    private final ImmutableHttpHostConfig indexClientConfig;
    private final IndexationClient indexClient;
    private PrefixedLogger logger;
    private ImmutableBaseServerConfig serverConfig;

    public IntegrationContext(
        final IndexationClient indexClient,
        final ImmutableHttpHostConfig indexClientConfig)
    {
        this.indexClient = indexClient;
        this.indexClientConfig = indexClientConfig;
    }

    public IntegrationContext logger(final PrefixedLogger logger) {
        this.logger = logger;
        return this;
    }

    public PrefixedLogger logger() {
        return logger;
    }

    public IntegrationContext serverConfig(
        final ImmutableBaseServerConfig serverConfig)
    {
        this.serverConfig = serverConfig;
        return this;
    }

    public ImmutableBaseServerConfig serverConfig() {
        return serverConfig;
    }

    public ImmutableHttpHostConfig indexClientConfig() {
        return indexClientConfig;
    }

    public IndexationClient indexClient() {
        return indexClient;
    }
}
