package ru.yandex.logbroker.log.consumer.integration.click;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import ru.yandex.search.prefix.Prefix;

public class Click {
    private final UserInfo user;
    private final List<Integer> mtypes;
    private String mid;
    private long thread;
    private boolean search;
    private String request;
    private String from;
    private double timestamp;
    private long index;

    public Click(final UserInfo userInfo) {
        this.user = userInfo;
        this.mtypes = new ArrayList<>();
    }

    public UserInfo userInfo() {
        return user;
    }

    public Prefix prefix() {
        return user.user().prefix();
    }

    public Long uid() {
        return user.uid();
    }

    public void search(final boolean search) {
        this.search = search;
    }

    public boolean search() {
        return search;
    }

    public void request(final String request) {
        this.request = request;
    }

    public String request() {
        return request;
    }

    public void index(final long index) {
        this.index = index;
    }

    public long index() {
        return index;
    }

    public void thread(final long thread) {
        this.thread = thread;
    }

    public long thread() {
        return thread;
    }

    public void mid(final String mid) {
        this.mid = mid;
    }

    public String mid() {
        return mid;
    }

    public double timestamp() {
        return timestamp;
    }

    public void timestamp(final double timestamp) {
        this.timestamp = timestamp;
    }

    public List<Integer> mtypes() {
        return mtypes;
    }

    public void mtypes(final Collection<Integer> mtypes) {
        this.mtypes.clear();
        this.mtypes.addAll(mtypes);
    }

    public String from() {
        return from;
    }

    public void from(final String from) {
        this.from = from;
    }

    @Override
    public String toString() {
        return "Click{"
            + "user=" + user
            + ", mid='" + mid + '\''
            + ", thread='" + thread + '\''
            + ", search=" + search
            + ", request='" + request + '\''
            + ", index=" + index
            + '}';
    }
}
