package ru.yandex.logbroker.log.consumer.integration.click;

import java.util.logging.Level;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.client.BasicRetryContext;
import ru.yandex.http.util.nio.client.ClientContext;
import ru.yandex.http.util.nio.client.RequestContext;
import ru.yandex.logger.PrefixedLogger;

public class InfiniteRetryContext<T> extends BasicRetryContext<T> {
    private static final int MIN_RETRY_LOGGING = 5;
    private int retries = 0;
    private final PrefixedLogger logger;
    private final String request;

    public InfiniteRetryContext(
        final RequestContext<T> requestContext,
        final ClientContext clientContext,
        final LoggableProducerSupplier<? extends HttpAsyncRequestProducer>
            producerSupplier)
    {
        super(requestContext, clientContext, producerSupplier);

        this.logger = producerSupplier.logger();
        this.request = producerSupplier.get().toString();
    }

    @Override
    public long nextRetryInterval(final Exception e) {
        long interval = -1L;
        switch (clientContext.detectErrorType(e)) {
            case IO:
                if (clientContext.ioRetries().count() == 0) {
                    interval = super.nextRetryInterval(e);
                } else {
                    interval = clientContext.ioRetries().interval();
                }

                retries += 1;
                break;
            case HTTP:
                if (clientContext.httpRetries().count() == 0) {
                    interval = super.nextRetryInterval(e);
                } else {
                    interval = clientContext.httpRetries().interval();
                }

                retries += 1;
                break;
            default:
                break;
        }

        if (retries >= MIN_RETRY_LOGGING && logger != null) {
            logger.log(
                Level.WARNING,
                "Request  " + request + " retry number " + retries,
                e);
        }

        return interval;
    }
}
