package ru.yandex.logbroker.log.consumer.integration.click;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.client.ClientContext;
import ru.yandex.http.util.nio.client.RequestContext;
import ru.yandex.http.util.nio.client.RetryContext;
import ru.yandex.http.util.nio.client.RetryContextFactory;

public class InfiniteRetryContextFactory implements RetryContextFactory {
    private final LoggableProducerSupplier<? extends HttpAsyncRequestProducer>
        producerSupplier;

    public InfiniteRetryContextFactory(
        final LoggableProducerSupplier<? extends HttpAsyncRequestProducer>
            producerSupplier)
    {
        this.producerSupplier = producerSupplier;
    }

    @Override
    public <T> RetryContext<T> create(
        final RequestContext<T> requestContext,
        final ClientContext clientContext)
    {
        return new InfiniteRetryContext<>(
            requestContext,
            clientContext,
            producerSupplier);
    }
}
